/*
 * Default LF_ERROR implementation. Macro must be called
 * with 1 arguement in parenthesis.
 */
#include <errno.h>

/*
 * prototypes
 */
void lf_error_print_nl (const char *fmt, ...);

#define LF_ERROR(p)                                 \
  do {                                              \
    errno = 0;					    \
    LF_ERROR_E(p);				    \
  } while (0)

#define LF_ERROR_E(p)                               \
  do {                                              \
    fprintf(stderr, "%s:%d: ", __FILE__, __LINE__); \
    lf_error_print_nl p ;                           \
    goto except;                                    \
  } while (0)
